;/***********************************************************************************
; Program		:Test a Magnetic Card Reader MODEL MCR-02TTL.
; Description	:send code to display on PC's monitor via RS232 interface.  
;				:plaese read datasheet of magnetic card before use it.
; CPU Control	:ATmega163
; File name		:Magcard.asm
; Assembler		:AVR Studio 4.05
;/************************************************************************************
.include "m163def.inc"
			.org	$000 
    		rjmp  	reset			;Reset Handle
			.org	$004
			rjmp	Service			;External Interrupt1,executed when 
;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19
.def		temp1		= r20
.def		data		= r21
.def		Flag		= r24
;/***********************
; Define I/O Port,Pin
;/***********************
.equ		Parityb		= 1
.equ		Errorb		= 2
.equ		Stopb		= 4
.equ		Startb		= 8
.equ		Datap 		= 4
.equ		Clkp		= 5
.equ		dat_adr		= $80
;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	
main:		sbi	UCR,TXEN
			sbi	UCR,RXEN
			ldi	temp,51
			out	UBRR,temp

MCR:		ldi	ZH,high(2*MCRTB)	 
			ldi	ZL,low(2*MCRTB)		
			rcall	Intro			;display message

;/*************************************************************
; External interrupt1 will be triged interrupt 
; by rising edge
;/**************************************************************
			sbi	DDRD,3				;define output port
			sbi	PORTD,3				;clere PORT D3 
			ldi	temp,0x08			;generate interrupt when 
			out	MCUCR,temp	 		;Present signal is falling edge
			ldi	temp,0x80			;enable external Interrupt1
			out	GIMSK,temp
			sei						;Enabled Global interrupt
			cbi	DDRD,Clkp
			cbi	DDRD,Datap
			sbi	PORTD,Clkp
			sbi	PORTD,Datap

wait:		rjmp	wait			;wait present signal

;/************************************************************
; Interrupt service routine : read code from a magnetic card
;/************************************************************	   	
Service:	rcall	Get_char	
			sbrs	Flag,0			;if parity bit = 0
			rjmp	chk_err			;go to check error 
			cbr	Flag,Parityb
			ldi	ZH,high(ParityTB*2)	;if parity bit = 1
			ldi	ZL,low(ParityTB*2)	;show message "parity error"
			rcall	Intro
			rjmp	ret_i

chk_err:	sbrs	Flag,1			;if error bit = 0
			rjmp	Display			;go to display

;/**************************************
; executed when error bit is set
;/**************************************
			cbr	Flag,Errorb
			ldi	ZH,high(2*ErrorTB)	;if error bit = 1
			ldi	ZL,low(2*ErrorTB)   ;show message
			rcall	Intro			;"check sum error"
			rjmp	ret_i

;/*********************************
; send data to serial port
;/*********************************
Display:	ldi	ZH,high(2*MCRTB1)
			ldi	ZL,low(2*MCRTB1)
			rcall	Intro
			ldi	YH,high(dat_adr)
			ldi	YL,low(dat_adr)
Displa1:	ld	data,Y+
			cpi	data,$0F
			breq	ret_i
			subi	data,-$30
			rcall	TX_Byte
			rjmp	Displa1

;/******************************************************
; send Line feed and Cariage Return before return int
;/******************************************************
ret_i:		ldi	data,0x0a
			rcall	TX_Byte
			ldi	data,0x0d
			rcall	TX_Byte
			reti
;/******************************************************
; get data 5 bits from data line
; note: bits form data line are not real data,
; so, we must convert it before kept it into register.
;/******************************************************
Get_char:	rcall	Clear_mem
			ldi	YH,high(dat_adr)
			ldi	YL,low(dat_adr)
			ldi	counter1,5			;5 bits
			ldi	counter2,0
			clr	temp1
Get_cha1:	rcall	Clock			
			sbic	PIND,Datap		;frist bit must be 0
			rjmp	Get_cha1
			sec
			ror	data
			inc	counter2
			dec	counter1
			cbr	Flag,Stopb
			sbr	Flag,Startb

Get_cha2:	rcall	clock
			clc
			sbic	PIND,Datap
			rjmp	Sub_getcha2
			sec
			inc	counter2
Sub_getcha2:	
			ror	data
			dec	counter1
			brne	Get_cha2
;/************************
; shift right 3 times
;/************************
			ldi	counter1,3
Ror3t:		ror	data
			dec	counter1
			brne	Ror3t
			sbrc	Flag,2			;skip if stop bit = 0	
			rjmp	Parity_OK
;/*****************
; check parity bit 
;/*****************			
			cpi	counter2,1
			breq	Parity_OK
			cpi	counter2,3
			breq	Parity_OK
			cpi	counter2,5
			breq	Parity_OK
			sbr	Flag,Parityb		;if parity bit is incorrect set parity bit
			rjmp	Mcr_ret

Parity_OK:	andi	data,0x0F
			sbrc	Flag,2
			rjmp	Check_err		;jump to check_err label if stop bit = 1
			push	data
			eor	temp1,data
			pop	data
			cpi	data,0x0F
			brne	Get_cha3
			sbr	Flag,Stopb
Get_cha3:	sbrs	Flag,3
			st	Y+,data				;keep data
			cbr	Flag,Startb
			ldi	counter2,0x00
			ldi	counter1,5
			rjmp	Get_cha2		;reread data

Check_err:	cp	data,temp1
			breq	MCR_ret
			sbr	Flag,Errorb
MCR_ret:	ret

Clock:		sbic	PIND,clkp
			rjmp	Clock
			nop
			nop
Clock1:		sbis	PIND,clkp		;if bit not set
			rjmp	Clock1			;wait more..
			nop
			nop
			ret

;/******************
; cleare memory
;/******************
Clear_mem:	ldi	counter1,40
			ldi	YH,high(dat_adr)
			ldi	YL,low(dat_adr)
			ldi	temp,0x00
Clear_mem1:	st	Y+,temp
			dec	counter1
			brne	Clear_mem1
			ret

;/*************
; Send Text
;/*************
Intro:		lpm
			tst	r0
			breq	end_sub
TX232:		sbis	USR,UDRE
			rjmp	TX232
			out	UDR,r0
			adiw	ZL,1
			rjmp	Intro
end_sub:	ret		
;/*************
; Send a byte
;/*************

TX_Byte:	sbis	USR,UDRE
			rjmp	TX_Byte
			out	UDR,data
			ret

;/****************
; Receive a byte
;/****************
RX_Byte:	sbis	USR,RXC
			rjmp	RX_Byte
			in	data,UDR
			ret

;/******************
; code segment
;/******************

MCRTB:		.db	"Test Magnetic Card Reader",0x0a,0x0d,"Model	: MCR-02TTL ",0x0a,0x0d,0
MCRTB1:		.db	"Your magnetic card code is ",0
ParityTB:	.db	"Parity Error!",0
ErrorTB:	.db	"Check sum Error! ",0	
           	 